library(httr)
library(jsonlite)
library(dplyr)

# Use case: search + download + csv


# credentials
username <- 'yourusername@abc.com'
password <- 'yourpassword'
apikey <- 'yourapikey'

# define csv file structure
data_all <- data.frame ("DossierID"=integer(),
                        "Name"=character(),
                        "BusinessAddress"=character(), 
                        "ResidenceAddress1"=character(),
                        "ResidenceAddress2"=character(), 
                        "ResidenceAddress3"=character(), 
                        "ResidenceAddress4"=character(), 
                        "ResidenceAddress5"=character(), 
                        stringsAsFactors=FALSE) 

# tracking search result pages, start with page 1, 2, 3, 4.. 
page = 1

# tracking number of rows to be stored in csv file
rowCount = 0

# limit number of rows to be stored in csv file
MAX_ROW_COUNT = 5

while (TRUE) 
{ 
  print(sprintf('............. Page %d .............', page))
  
  # Post a search query
  r <- POST("https://connect.wealthx.com/rest/v1/dossiers/search/advanced",
            add_headers(c('username'=username,
                          'password'=password,
                          'apikey'=apikey,
                          'accept'='application/json')),
            body = list( 
              locationType='Residence,Business,Hometown',
              countryID=1,
              networthMin=format(100000000, scientific = FALSE),
              tafMin=format(100000000, scientific = FALSE),
              page=page,
              pageSize=20,
              orderBy='networthLower',
              sortDirection='descending'
              )
  )
  stop_for_status(r)
  
  # Get the total# and found dossier IDs
  json_search <- fromJSON(content(r, as="text", encoding = 'UTF-8'))
  
  if(rowCount==0 && !(is.null(json_search$searchResult$totalHits)))
    print(sprintf('Total number of dossiers found: %d ................', json_search$searchResult$totalHits))
  
  if(is.null(json_search$searchResult$hits))
  {
      print("End of search results")
      break
  }
  
  
  # Iterating the search results returned from this page with dossier IDs
  for(i in 1:nrow(json_search$searchResult$hits))
  {
    
    hit <- json_search$searchResult$hits[i,]
  
   
    # Call /dossiers endpoint of this dossier to get detailed dossier information by dossier id
    d <- GET(paste("https://connect.wealthx.com/rest/v1/dossiers/", hit$ID, sep=''),
             add_headers(c('username'=username,
                           'password'=password,
                           'apikey'=apikey,
                           'accept'='application/json'))
    ) 
    stop_for_status(d)
    
    # Retrieve dossier info
    json_dossier <- fromJSON(content(d, as="text", encoding = 'UTF-8'))
    print(sprintf("#%d - Dossier: %d, Name: %s %s", (rowCount+1), json_dossier$profilebasic$ID, 
                  json_dossier$profilebasic$firstName, json_dossier$profilebasic$lastName))


    # Insert dossier info to Dataframe
    
    # Dossier ID and Name
    data_all[nrow(data_all)+1, "DossierID"] <- json_dossier$profilebasic$ID
    data_all[nrow(data_all) , "Name"] <- paste(json_dossier$profilebasic$firstName, json_dossier$profilebasic$lastName, sep =' ')
    
    # Business Address
    if(!is.null(json_dossier$profilebasic$businessContact))
      data_all[nrow(data_all) , "BusinessAddress"] <- paste(json_dossier$profilebasic$businessContact$street,
                                                            json_dossier$profilebasic$businessContact$city,
                                                            json_dossier$profilebasic$businessContact$state,
                                                            json_dossier$profilebasic$businessContact$zipcode,
                                                            json_dossier$profilebasic$businessContact$country,
                                                            sep = ',')
    
    # Residence Address
    if(!is.null(json_dossier$profilebasic$residences))
    {
      for(j in 1:nrow(json_dossier$profilebasic$residences))
      {
        if(j <=5) # Limit to 5 resience address as defined in CSV file structure
          data_all[nrow(data_all) , paste("ResidenceAddress", j, sep='')] <- paste(json_dossier$profilebasic$residences[j, "city"],
                                                                                   json_dossier$profilebasic$residences[j, "state"],
                                                                                   json_dossier$profilebasic$residences[j, "zipcode"],
                                                                                   json_dossier$profilebasic$residences[j, "country"],
                                                                                   sep = ',')
                                                                                   
      }
    }
    
    # one row added
    rowCount <- rowCount + 1
    
    # Limit number of rows to be stored in csv for demo purpose
    if(rowCount>=MAX_ROW_COUNT) 
      break # exit this page
  }
  
  # Limit number of rows to be stored in csv for demo purpose
  if(rowCount>=MAX_ROW_COUNT) 
    break # stop navigating to next page

  # Navigate to next page of search results
  page <- page + 1
}
  
  
# Write the DataFrame to csv file
print("See output.csv for samples")
write.csv(data_all, file = "output.csv", row.names=FALSE)



